//*****************************************************************************
//*****************************************************************************

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "custsamp.h"

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
// Property: SAMPLE CUSTOM PROPERTY (Same as stock BOOLEAN property)
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
SPG_CustProp::SPG_CustProp( SWindow *parent, stPropGroup *pstProp, stPropInfo *pstInfo ) 
: SPropGroup( parent, pstProp, pstInfo )
{
}

//-------------------------------------------------------------------------
SPG_CustProp::~SPG_CustProp()
{
}

//-------------------------------------------------------------------------
BOOL SPG_CustProp::HandlePropMessage( UINT uMessage, WPARAM wParam, LPARAM )
{
   BOOL bRet = FALSE;
   
   switch( uMessage )
   {
      case WM_INITDIALOG:
      {
         char szButtonText[MAX_CTLTEXT];                  
         SInspectStruct stPI;                     
         SInspectObjList *pListCsr = pObj;                  
         while( pListCsr )
         {      
            // Get the text to use for the check box text
            *szButtonText = '\0';
            stPI.uMessage = PI_INITPROP;
            stPI.uProperty = uClientPropID; // Identify the property
            stPI.pszValue = (LPSTR)szButtonText;
            
            if( pfSInspectProc( pListCsr->pObj, &stPI ) )
            {
               // Only need to get it once.  First obj that replies positive.
               break;
            }
            pListCsr = pListCsr->next;
         }
         
         // Set the check box text if not empty string. Otherwise, use default in dlg.
         if( *szButtonText )
         {
            SetDlgItemText( hWindow, IDC_BOOLEAN, szButtonText );
         }
         
         // Calling GetProp_xxxValue initializing value         
         CheckDlgButton( hWindow, IDC_BOOLEAN, GetProp_iValue( TRUE, TRUE ) );
         
         SetFocus( GetDlgItem( hWindow, IDC_BOOLEAN ) );
         bRet = FALSE;
         break;         
      }        
      
      case WM_COMMAND:
      {
         switch( wParam )
         {
            case IDC_BOOLEAN:
            {
               SetProp_uValue( IsDlgButtonChecked( hWindow, IDC_BOOLEAN ) );               
               
               bRet = TRUE;
               break;
            }
         }
         break;
      }            
   }
   return bRet;
}

//-------------------------------------------------------------------
void SPG_CustProp::DisplayValue( UndoRedoValue &urValue ) 
{
   CheckDlgButton( hWindow, IDC_BOOLEAN, urValue.iValue );
}
