//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>

#include "sampobj.h"  
#include "otapi.h"
#include "ids.h"
#include "custsamp.h"

extern HINSTANCE hInst;

static void GetPropertyInfo( SInspectStruct *pstSInspect );

int CSampleObj::iCounter = 0;

//------------------------------------------------------------------------------
CSampleObj::CSampleObj()
{
   iCounter++;      
}

//------------------------------------------------------------------------------
CSampleObj::CSampleObj( HWND hwnd, RECT *prcSize )
{
   iCounter++;
   
   hwndParent = hwnd;

   rcExtent = *prcSize;

   crLabel      = GetSysColor( COLOR_BTNTEXT );
   crBackground = GetSysColor( COLOR_BTNFACE );
   crFrame      = GetSysColor( COLOR_WINDOWFRAME );

   uMagnifyFact = 1;
   bInverse     = FALSE;
   enFrameStyle = eNormal;
   uTool        = 0;

   hfText = NULL; // Use system font as default

   pszLabel = new char[64];
   strcpy( pszLabel, STR_SAMPLEOBJ );
   char szNum[32];
   strcat( pszLabel, itoa( iCounter, szNum, 10 ) );   
}

//------------------------------------------------------------------------------
CSampleObj::~CSampleObj()
{
   delete [] pszLabel;
}

//------------------------------------------------------------------------------
void CSampleObj::SetLabelText( char *pszText )
{
   if( !pszText )
   {
      return;
   }

   delete [] pszLabel;

   pszLabel = new char[strlen( pszText )+1];
   strcpy( pszLabel, pszText );

   Invalidate();   
}

//------------------------------------------------------------------------------
void CSampleObj::Paint( HDC hDC )
{
   RECT rcClient;
   GetClientRect( hwndParent, &rcClient );
   HDC hDCMem = CreateCompatibleDC( hDC );
   HBITMAP hBmp = CreateCompatibleBitmap( hDC, rcClient.right, rcClient.bottom );
   HBITMAP hBmpOld = (HBITMAP)SelectObject( hDCMem, hBmp );

   HPEN hpenOld = NULL;
   if( enFrameStyle )
   {
      hpenOld = (HPEN)SelectObject( hDCMem, CreatePen( PS_SOLID, enFrameStyle, crFrame ) );
   }
   else
   {
      SelectObject( hDCMem, GetStockObject( NULL_PEN ) );
   }
   HBRUSH hbrOld = (HBRUSH)SelectObject( hDCMem, CreateSolidBrush( crBackground ) );
   SetTextColor( hDCMem, crLabel );
   SetBkMode( hDCMem, TRANSPARENT );

   if( hfText )
   {
      SelectObject( hDCMem, hfText );
   }

   UINT uOffset = enFrameStyle ? enFrameStyle - 1 : 0;
   Rectangle( hDCMem, rcExtent.left+uOffset, rcExtent.top+uOffset, 
                      rcExtent.right-uOffset, rcExtent.bottom-uOffset );
   DrawText( hDCMem, pszLabel, -1, &rcExtent, DT_CENTER | DT_VCENTER | DT_SINGLELINE );

   if( bInverse )
   {
      InvertRect( hDCMem, &rcExtent );
   }

   if( hpenOld )
   {
      DeleteObject( SelectObject( hDCMem, hpenOld ) );
   }
   DeleteObject( SelectObject( hDCMem, hbrOld ) );

   BitBlt( hDC, 
           rcExtent.left, rcExtent.top, 
           rcExtent.right - rcExtent.left, rcExtent.bottom - rcExtent.top,
           hDCMem,
           rcExtent.left, rcExtent.top,
           SRCCOPY );
   DeleteObject( SelectObject( hDCMem, hBmpOld ) );
   DeleteDC( hDCMem );
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//
// This function represents an interface to the property inspector.
//
//------------------------------------------------------------------------------
BOOL CALLBACK _export CSampleObj::SInspectProc( void *self, SInspectStruct *pstSInspect )
{
   BOOL bRet = TRUE;
   
   // SInspectObjList *pSampObjList = NULL;
   CSampleObj      *pSelf = NULL;

   if( pstSInspect->uMessage == PI_GETOBJECTNAME ||
       pstSInspect->uMessage == PI_KILLSELECT )
   {
      // pSampObjList = (SInspectObjList *)self;
      
      // NOTE: The entire list is passed in as self parameter in context of the
      //       PI_GETOBJECTNAME and PI_KILLSELECT messages.  Since this example 
      //       does not respond to these messages we comment out pSampleObjList.
   }
   else
   {
      pSelf = (CSampleObj *)self;
   }

   switch( pstSInspect->uMessage )
   {
      //
      // Set a name string representing this object
      //
      case PI_GETOBJECTNAME:
         strcpy( (char *)pstSInspect->pValue, STR_SAMPLEOBJ );
         break;
         
      //
      // Supply the object's property info
      //
      case PI_GETPROPERTIES:
         GetPropertyInfo( pstSInspect );
         break;

      //
      // Expose a specified custom property
      //
      case PI_GETCUSTOMPROP:
      {
         static stPropGroup pCustProps[] =
         {
            { PROPID_MYCUSTPROP, NULL, "CUST_000", NULL, },
         };
         
         // Can't initialize instance until our hInst has been assigned
         pCustProps[0].hInst = hInst; 
         
         switch( pstSInspect->uProperty )
         {
            case PROPID_MYCUSTPROP:
               // Offset 0 in the array
               pstSInspect->pValue = (void *)&pCustProps[0];
               break;
               
            default:
               bRet = FALSE;
         }
         break;
      }
      
      //
      // Create an instance of a specified custom property
      //
      case PI_CREATECUSTOMPG:
      {
         switch( pstSInspect->uProperty )
         {
            case PROPID_MYCUSTPROP:
            {
               stCustomPG *pCust = (stCustomPG *)pstSInspect->pValue;

               pCust->propGroup = new SPG_CustProp( pCust->inspector,
                                                    pCust->pstPropGroup,
                                                    pCust->pstPropInfo );
               break;
            }
            
            default:
               bRet = FALSE;
         }
         break;
      }
      
      //
      // Initialize the property
      //
      case PI_INITPROP:
      {
         switch( pstSInspect->uProperty )
         {
            // Frame Style - PROPID_LISTSINGLE needs strings for the list
            case PID_FRAMESTYLE:
            {            
               char *pszItem = new char[MAX_CTLTEXT];
               for( UINT uID = ID_FRAME__FIRST; uID <= ID_FRAME__LAST; uID++ )
               {
                  LoadString( hInst, uID, pszItem, MAX_CTLTEXT );
                  ((ADDSTRINGPROC)pstSInspect->pValue)( pszItem );
               }
               delete pszItem;

               break;
            }

            // Inverse - PROPID_BOOLEAN needs a string for the checkbox label
            case PID_INVERSE:
               LoadString( hInst, ID_INVERSE, pstSInspect->pszValue, MAX_CTLTEXT );                              
               break;

            // Magnification Factor - PROPID_INTEGER needs min and max values
            case PID_MAGNIFYFACT:
               pstSInspect->dwValue = (DWORD)MAKELONG( 5, 1 );
               break;

            // Tools - PROPID_LISTSINGLEBMP needs bitmap[s]
            case PID_TOOLS:
            {
               LISTSINGLEBITMAPSTRUCT *pLSBS = (LISTSINGLEBITMAPSTRUCT *)pstSInspect->pValue;
               pLSBS->uIdBmp = BMP_TOOLS;
               pLSBS->uItems = 8;
               break;
            }

            // Colors - PROPID_COMPOUND needs an icon id and some text
            case PID_COMP_COLORS:
            {
               COMPOUNDSTRUCT *pCS = (COMPOUNDSTRUCT *)pstSInspect->pValue;
               pCS->uIdIcon = ICN_COLORS;
               LoadString( hInst, ID_COMP_SAMPLE, pCS->pszDescription, MAX_CTLTEXT );
               break;
            }
            
            // Miscellaneous - PROPID_COMPOUND needs an icon id and some text
            case PID_COMP_MISC:
            {
               COMPOUNDSTRUCT *pCS = (COMPOUNDSTRUCT *)pstSInspect->pValue;
               pCS->uIdIcon = 0;  // Using default icon
               LoadString( hInst, ID_COMP_MISC, pCS->pszDescription, MAX_CTLTEXT );
               break;
            }
            
            // Toggle - PROPID_MYCUSTPROP needs a string for the checkbox label
            case PID_MYCUSTPROP:
               LoadString( hInst, ID_PROP_MYCUSTPROP, pstSInspect->pszValue, MAX_CTLTEXT );                              
               break;

            default:
               bRet = FALSE;
               break;
         }
         break;
      }

      //
      // Supply a specified property value
      //
      case PI_GETVALUE:
      {
         switch( pstSInspect->uProperty )
         {
            // Label Text
            case PID_LABELTEXT:
            {
               pstSInspect->pszValue = pSelf->GetLabelText();
               bRet = TRUE;
               break;
            }
               
            // Colors
            case PID_COLOR_BACK:
               pstSInspect->dwValue = pSelf->GetColorBackground();
               bRet = TRUE;
               break;
            case PID_COLOR_LABEL:
               pstSInspect->dwValue = pSelf->GetColorLabel();
               bRet = TRUE;
               break;
            case PID_COLOR_FRAME:
               pstSInspect->dwValue = pSelf->GetColorFrame();
               bRet = TRUE;
               break;

            // Font Text
            case PID_FONTTEXT:
            {
               LOGFONT lf;
               FONTINFOSTRUCT *pFont = (FONTINFOSTRUCT *)pstSInspect->pValue;

               if( GetObject( pSelf->GetFontText(), sizeof( LOGFONT ), &lf ) )
               {
                  strcpy( pFont->szFace, lf.lfFaceName );
                  pFont->uPoints    = lf.lfHeight;
                  pFont->bBold      = (lf.lfWeight > FW_MEDIUM);
                  pFont->bUnderline = lf.lfUnderline;
                  pFont->bItalic    = lf.lfItalic;
                  pFont->bPrinter   = 0;
               }
               else
               {
                  strcpy( pFont->szFace, "SYSTEM" );
                  pFont->uPoints    = 10;
                  pFont->bBold      = 0;
                  pFont->bUnderline = 0;
                  pFont->bItalic    = 0;
                  pFont->bPrinter   = 0;
               }
               break;
            }

            // Frame Style
            case PID_FRAMESTYLE:
               pstSInspect->iValue = (int)pSelf->GetFrameStyle();
               bRet = TRUE;
               break;

            // Inverse
            case PID_INVERSE:
               pstSInspect->iValue = pSelf->GetInverse();
               bRet = TRUE;
               break;

            // Magnify Factor
            case PID_MAGNIFYFACT:
               pstSInspect->uValue = pSelf->GetMagnifyFact();
               bRet = TRUE;
               break;

            // Tool
            case PID_TOOLS:
               pstSInspect->uValue = pSelf->GetTool();
               bRet = TRUE;
               break;

            // Toggle (Using CUSTOM property here)
            case PID_MYCUSTPROP:
               pstSInspect->iValue = pSelf->GetToggle();
               bRet = TRUE;
               break;
               
            default:
               bRet = FALSE;
         }
         break;
      }

      //
      // Set a specified property value
      //
      case PI_SETVALUE:
      {
         switch( pstSInspect->uProperty )
         {
            // Label Text
            case PID_LABELTEXT:
               pSelf->SetLabelText( pstSInspect->pszValue );
               bRet = TRUE;
               break;
         
            // Colors
            case PID_COLOR_BACK:
               pSelf->SetColorBackground( pstSInspect->dwValue );
               bRet = TRUE;
               break;
            case PID_COLOR_LABEL:
               pSelf->SetColorLabel( pstSInspect->dwValue );
               bRet = TRUE;
               break;
            case PID_COLOR_FRAME:
               pSelf->SetColorFrame( pstSInspect->dwValue );
               bRet = TRUE;
               break;

            // Font Text
            case PID_FONTTEXT:
            {
               FONTINFOSTRUCT *pFont = (FONTINFOSTRUCT *)pstSInspect->pValue;
               LOGFONT lf;
               memset( &lf, 0, sizeof( LOGFONT ) );

               strcpy( lf.lfFaceName, pFont->szFace );
               lf.lfHeight    = pFont->uPoints;
               lf.lfWeight    = pFont->bBold ? FW_BOLD : FW_NORMAL;
               lf.lfItalic    = pFont->bItalic;
               lf.lfUnderline = pFont->bUnderline;

               lf.lfCharSet        = ANSI_CHARSET;
               lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
               lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
               lf.lfPitchAndFamily = FF_DONTCARE;
               
               pSelf->SetFontText( CreateFontIndirect( &lf ) );

               bRet = TRUE;
               break;
            }

            // Frame Style
            case PID_FRAMESTYLE:
               pSelf->SetFrameStyle( (FrameStyle)pstSInspect->iValue );
               bRet = TRUE;
               break;

            // Inverse
            case PID_INVERSE:
               pSelf->SetInverse( pstSInspect->iValue );
               bRet = TRUE;
               break;

            // Magnify Factor
            case PID_MAGNIFYFACT:
               pSelf->SetMagnifyFact( pstSInspect->uValue );
               bRet = TRUE;
               break;

            // Tools
            case PID_TOOLS:
               pSelf->SetTool( pstSInspect->uValue );
               bRet = TRUE;
               break;

            // Toggle (Using CUSTOM property here)
            case PID_MYCUSTPROP:
               pSelf->SetToggle( pstSInspect->iValue );
               bRet = TRUE;
               break;

            default:
               bRet = FALSE;
         }
         break;
      }

      default:
         bRet = FALSE;

   }
   return bRet;
}

//------------------------------------------------------------------------------
static void GetPropertyInfo( SInspectStruct *pstSInspect )
{
   UINT uPropCount  = 0;
   static stPropInfo pstTestProps[MAX_PROPERTIES];

   //
   // Properties info
   //
   stPropInfo pstProps[] =
   {
      { PID_LABELTEXT,     PROPID_NAME,           ID_PROP_LABELTEXT,   -1, hInst, PIF_MULTPROP,                NULL },
      { PID_FONTTEXT,      PROPID_FONT,           ID_PROP_FONTTEXT,    -1, hInst, PIF_MULTPROP,                NULL },
      { PID_TOOLS,         PROPID_LISTSINGLEBMP,  ID_PROP_TOOLS,       -1, hInst, PIF_LISTBITMAP_VMATRIX | PIF_MULTPROP,                NULL },
      { PID_COMP_COLORS,   PROPID_COMPOUND,       ID_PROP_COLORS,      -1, hInst, PIF_COMPOUND | PIF_MULTPROP, PID_COMP_COLORS },
         { PID_COLOR_LABEL,   PROPID_COLORREF,      ID_PROP_COLOR_LABEL, -1, hInst, PIF_MULTPROP,                PID_COMP_COLORS },      
         { PID_COLOR_BACK,    PROPID_COLORREF,      ID_PROP_COLOR_BACK,  -1, hInst, PIF_MULTPROP,                PID_COMP_COLORS },                  
         { PID_COLOR_FRAME,   PROPID_COLORREF,      ID_PROP_COLOR_FRAME, -1, hInst, PIF_MULTPROP,                PID_COMP_COLORS },                           
      { PID_COMP_MISC,     PROPID_COMPOUND,       ID_PROP_MISC,        -1, hInst, PIF_COMPOUND | PIF_MULTPROP, PID_COMP_MISC },
        { PID_FRAMESTYLE,     PROPID_LISTSINGLE,    ID_PROP_FRAMESTYLE,  -1, hInst, PIF_MULTPROP,                PID_COMP_MISC },
        { PID_INVERSE,        PROPID_BOOLEAN,       ID_PROP_INVERSE,     -1, hInst, PIF_MULTPROP,                PID_COMP_MISC },
        { PID_MAGNIFYFACT,    PROPID_INTEGER,       ID_PROP_MAGNIFYFACT, -1, hInst, PIF_MULTPROP | PIF_INTEGER_UNSIGNED, PID_COMP_MISC },
      { PID_MYCUSTPROP,    PROPID_MYCUSTPROP,     ID_PROP_MYCUSTPROP,    -1, hInst, PIF_MULTPROP,              NULL },        
   };
   
   uPropCount = sizeof(pstProps) / sizeof(stPropInfo);
   memset( pstTestProps, 0, sizeof(pstTestProps) );
   memcpy( pstTestProps, pstProps, sizeof(pstProps) );
   
   // Number of properties
   pstSInspect->uProperty = uPropCount;

   // Property info
   pstSInspect->pValue = (void *)pstTestProps;
}
