//*****************************************************************************
//*****************************************************************************

#ifndef _SAMPOBJ_H
#define _SAMPOBJ_H

#define STR_SAMPLEOBJ "Sample Object"

// Forward declare
struct SInspectStruct;

enum FrameStyle { eNone, eNormal, eThick, eExThick };

class CSampleObj
{
public:
   CSampleObj();
   CSampleObj( HWND hwnd, RECT *prcSize );

   ~CSampleObj();

   void       SetLabelText( char * );
   char *     GetLabelText() { return pszLabel; }

   void       SetColorLabel( COLORREF crColor ) { crLabel = crColor; Invalidate(); }
   COLORREF   GetColorLabel() { return crLabel; }

   void       SetColorBackground( COLORREF crColor ) { crBackground = crColor; Invalidate(); }
   COLORREF   GetColorBackground() { return crBackground; }

   void       SetColorFrame( COLORREF crColor ) { crFrame = crColor; Invalidate(); }
   COLORREF   GetColorFrame() { return crFrame; }

   void       SetFontText( HFONT hfNew ) { DeleteObject( hfText ); hfText = hfNew; Invalidate(); }
   HFONT      GetFontText() { return hfText; }

   void       SetMagnifyFact( UINT uNewFact ) { uMagnifyFact = uNewFact; Invalidate(); }
   UINT       GetMagnifyFact() { return uMagnifyFact; }

   void       SetFrameStyle( FrameStyle enNewStyle ) { enFrameStyle = enNewStyle; Invalidate(); }
   FrameStyle GetFrameStyle() { return enFrameStyle; }

   void       SetInverse( BOOL bNewInverse ) { bInverse = bNewInverse; Invalidate(); }
   BOOL       GetInverse() { return bInverse; }

   void       SetTool( UINT uNewTool ) { uTool = uNewTool; Invalidate(); }
   BOOL       GetTool() { return uTool; }

   void       SetExtent( RECT &rc ) { rcExtent = rc; }
   void       GetExtent( RECT &rc ) { rc = rcExtent; }

   void       SetToggle( BOOL bNewToggle ) { bToggle = bNewToggle; }
   BOOL       GetToggle() { return bToggle; }

   // Painting
   void Paint( HDC hDC );
   void Invalidate() { InvalidateRect( hwndParent, &rcExtent, FALSE ); }

   // Inspector interface callback
   static BOOL CALLBACK SInspectProc( void *pSelf, SInspectStruct *pstSInspect );

private:
   HWND hwndParent;

   char *pszLabel;

   COLORREF crLabel;
   COLORREF crBackground;
   COLORREF crFrame;

   HFONT hfText;
   RECT rcExtent;

   UINT uMagnifyFact;
   BOOL bInverse;
   FrameStyle enFrameStyle;
   UINT uTool;
   BOOL bToggle;

   static int iCounter;   
};

#endif // _SAMPOBJ_H