
#include "stdafx.h"
#include "setup.h"
#include "mysetup.h"
#include "pmdde.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW


CMySetup::CMySetup()
{
	m_pDlgCopy = NULL;
}

CMySetup::~CMySetup()
{
	DestroyCopyDlg();
}

void CMySetup::DestroyCopyDlg()
{
	if (m_pDlgCopy) {	// just in case
		m_pDlgCopy->DestroyWindow();
		delete m_pDlgCopy;
		m_pDlgCopy = NULL;
	}
}


///////////////////////////////////////
// GetProductPresent(): use this function to determine the presence of this product
// if TRUE: strCurrentPath must contain the sub directory where it resides.
BOOL CMySetup::GetProductPresent(CString& strCurrentPath)
{
	return FALSE;
}


CSetup::eDlgRet CMySetup::DoDlgWelcome()
{
	eDlgRet ret = DR_ERROR;

	CDlgWelcome *pDlg = new CDlgWelcome(m_pWndParent);
	pDlg->m_pszProductName = GetProductName();
	switch (pDlg->DoModal()) {
		case IDCANCEL:
			ret = DR_EXIT;
			break;

		case IDOK:
			ret = DR_CONTINUE;
			break;
			
		default:
			break;
	}	// switch
	delete pDlg;

	return ret;
}


CSetup::eDlgRet CMySetup::DoDlgDestination(CString& strDestination )
{
	eDlgRet ret = DR_ERROR;

	CDlgPath *pDlg = new CDlgPath(m_pWndParent);
	pDlg->m_strPath = strDestination;
	pDlg->m_pszProductName = GetProductName();
	switch (pDlg->DoModal()) {
		case IDCANCEL:
			ret = DR_EXIT;
			break;
		
		case IDOK:
			strDestination = pDlg->m_strPath;
			ret = DR_CONTINUE;
			break;
			
		case IDC_BACK:
			ret = DR_BACK;
			break;

		default:
			break;
	}	// switch
	delete pDlg;

	return ret;
}


CSetup::eSuccess CMySetup::DoSetup()
{
	// HERE: call CSetup member functions for:
	// 		- copying files
	//		- adding PM groups/items
	//		- creating ini keys (if absolutely necessary only)
	eSuccess es = ES_ERROR;
	if (ReadAllFileLists()
		&& CopyFileLists()
		&& CreatePMItems("PMGroups") ) {
		es = ES_INSTALLED;
	}	// if readfilelist...
	return es;
}

BOOL CMySetup::ReadAllFileLists()
{
	BOOL bOk = TRUE;
	char *pszSection = new char[128];
	for (int i = 1; i<1000; i++ ) {
		wsprintf(pszSection, "Files%d", i);
		bOk = ReadFileList(pszSection);
		if (!bOk) {
			// check whether this section exists
			char szValue[5];
			if (::GetPrivateProfileString(pszSection, "File1", "", szValue, 5, m_strSetupFileName)==0) {
				bOk = TRUE;
			}
			break;
		}
	}	// for i
	delete [] pszSection;
	return bOk;
}

void CMySetup::InformUserOnCopy(int nPercentage, const char *pszSource/*=NULL*/, const char *pszDest/*=NULL*/)
{

	if (nPercentage<0)  {
		DestroyCopyDlg();
	}
	else {
		if (m_pDlgCopy==NULL)
			m_pDlgCopy = new CDlgCopy(m_pWndParent);      // modeless dialog
		
		m_pDlgCopy->SetNewData(nPercentage, pszSource, pszDest);
	}
}

void CMySetup::DoDlgExitWindows()
{
	// windows will be restarted now
	CDlgMsgOk dlg;
	dlg.m_strMsg.LoadString(IDS_EXITWIN);
	dlg.DoModal();
}

void CMySetup::DoDlgMustTerminateApps()
{
	// windows could not be restarted
	CDlgMsgOk dlg;
	dlg.m_strMsg.LoadString(IDS_MUSTEXITWIN);
	dlg.DoModal();
}

CSetup::eDlgRet CMySetup::DoDlgError(CSetupError *pErr)
{
	// called upon unexpected error
	// may return DR_CONTINUE or DR_EXIT
	// Dialog returns IDOK or IDCANCEL
	CDlgError dlg;
	dlg.m_pszProductName = GetProductName();
	if (pErr->m_nResFlags & CSetupError::respSkip) {
		dlg.m_bSkip = TRUE;
	}

	UINT nID;
	switch (pErr->m_eType) {
		case CSetupError::Syntax:
			nID = IDS_SYNTAX;
			break;
		case CSetupError::DiskSpace:
			nID = IDS_DISK_FULL;
			break;
		case CSetupError::PMGroup:
			nID = IDS_PMGROUP;
			break;
		case CSetupError::PMItem:
			nID = IDS_PMITEM;
			break;
		case CSetupError::FileAccess:
			nID = IDS_FILEACCESS;
			break;
		case CSetupError::FileType:
			nID = IDS_DIFFTYPE;
			break;
		case CSetupError::FileOS:
			nID = IDS_DIFFOS;
			break;
		case CSetupError::FileError:
			nID = IDS_FILEERROR;
			break;
		case CSetupError::FileNotFound:
			nID = IDS_FILENOTFOUND;
			break;
		case CSetupError::PathNotFound:
			nID = IDS_PATHNOTFOUND;
			break;
		case CSetupError::FileNotUnlocked:	// can happen in WOW or win32
			nID = IDS_FILELOCKED;
			break;
		default:
			nID = IDS_UNKNOWNERROR;
	}
	
	AfxFormatString1(dlg.m_strMsg, nID, pErr->m_strInfo);

	if (dlg.DoModal()==IDOK)
		return DR_CONTINUE;
	else
		return DR_EXIT;
}


void CMySetup::DoDlgEnd(eSuccess es)
{
	int nID;
	switch (es) {
		case ES_INSTALLED:
			nID = IDS_INSTALLED;
			break;

        case ES_NOT_INSTALLED:
            nID = IDS_NOT_INSTALLED;
            break;
        
		default:
		case ES_ERROR:
			nID = IDS_INSTALL_ERROR;
			break;
	} // switch es
	CString strText;
	AfxFormatString1(strText, nID, GetProductName());
	AfxMessageBox(strText);

}

