// MYSETUP: class derived from abstract class CSetup

#include "csetup.h"
#include "dlgs.h"

class CMySetup: public CSetup
{
public:
	CMySetup();
	~CMySetup();                      
                      
// overridden functions, called by base class CSetup:
	virtual BOOL GetProductPresent(CString& strCurrentPath);
    // dialogs
	virtual eDlgRet DoDlgWelcome();
	virtual eDlgRet DoDlgDestination(CString& strDestination );
	virtual eSuccess DoSetup();
	virtual void InformUserOnCopy(int nPercentage, const char *pszSource=NULL, const char *pszDest=NULL);
	virtual void DoDlgExitWindows();	// shared files should be updated
	virtual void DoDlgMustTerminateApps(); // exitwin did not work: MUST terminate

	virtual eDlgRet DoDlgError(CSetupError *pErr);

    virtual void DoDlgEnd(eSuccess es);

	// helpers
protected:
	void DestroyCopyDlg();
	BOOL ReadAllFileLists();
private:
	CDlgCopy	*m_pDlgCopy;

};
