//////////////////////////////////////////////////
//
// VerStamp.cpp: class interface to version resource info
// Both WIN16 and WIN32S
// See also MSVC SDK example VERSTAMP.C (many errors/shortcomings)
// Written by Mart van Ineveld, january 1994



#include "afx.h"
#include "afxwin.h"
#include "verstamp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW




///////////////////////////////////////////////////////////////////////////////
// CVerStamp

// constants/types used by VerQueryValue
static const char gszRoot[] = "\\";
static const char gszTrans[] = "\\VarFileInfo\\Translation";

CVerStamp::CVerStamp()
{
	m_hVerInfo = NULL;
	m_lpInfo = NULL;
	m_lpTrans = NULL;
	m_wLanguages = 0;
	m_wCurrentLanguage = 0;
}

CVerStamp::~CVerStamp()
{
	DeleteAttribs();
}


BOOL CVerStamp::GetVersionInfo(const char * pszFileName)	// TRUE: version info obtained
{
	DeleteAttribs();
	m_wCurrentLanguage = 0;
	DWORD dwSize =	GetFileVersionInfoSize((LPSTR)pszFileName, &m_hVerInfo);
	if (dwSize!=0) {
		m_lpInfo = new BYTE [(int) dwSize];
		if (GetFileVersionInfo((LPSTR)pszFileName, m_hVerInfo, dwSize, m_lpInfo)) {
			// get translation
			UINT wSize;
			if (VerQueryValue ((LPVOID) m_lpInfo, (LPSTR)gszTrans, (void FAR* FAR*)&m_lpTrans,&wSize)) {
				m_wLanguages = (wSize / sizeof(TRANS));
			}
			else {
				m_lpTrans = NULL;
				m_wLanguages = 0;
			} // if get translation
			return TRUE;
		}
	} // if dwsize
	return FALSE;
}


const VS_FIXEDFILEINFO FAR * CVerStamp::GetFixedFileInfo() const
{
    // get fixed file info from the ROOT "\\"
	if (m_lpInfo) {
	    VS_FIXEDFILEINFO FAR* lpffi = NULL;
		UINT nLen;
		if ( (VerQueryValue((LPVOID)m_lpInfo, (LPSTR)gszRoot,  (void FAR* FAR*)&lpffi, &nLen))
				&& nLen && lpffi) {
			return lpffi;
		}
	}
	return NULL;
}

BOOL CVerStamp::SelectLanguage(WORD wID ) // index, starts with 0
{
	if  ( (m_lpInfo) && (wID<m_wLanguages) ) {
		m_wCurrentLanguage = wID;
		return TRUE;
	}
	return FALSE;
}

    
	// required info in stamp:
BOOL CVerStamp::GetFileVersion(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"FileVersion");
}

BOOL CVerStamp::GetFileDescription(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"FileDescription");
}

BOOL CVerStamp::GetOriginalName(CString& strInfo ) const
{
	return QueryStringInfo(strInfo, "OriginalFilename");
}

BOOL CVerStamp::GetInternalName(CString& strInfo ) const
{
	return QueryStringInfo(strInfo, "InternalName");
}

BOOL CVerStamp::GetProductName(CString& strInfo ) const
{
	return QueryStringInfo(strInfo, "ProductName");
}

BOOL CVerStamp::GetProductVersion(CString& strInfo ) const
{
	return QueryStringInfo(strInfo, "ProductVersion");
}

BOOL CVerStamp::GetCompanyName(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"CompanyName" );
}

	// optional info in stamp:
BOOL CVerStamp::GetLegalCopyright(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"LegalCopyright");
}

BOOL CVerStamp::GetLegalTrademarks(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"LegalTrademarks");
}

BOOL CVerStamp::GetPrivateBuild(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"PrivateBuild");
}

BOOL CVerStamp::GetSpecialBuild(CString& strInfo ) const
{
	return QueryStringInfo(strInfo,"SpecialBuild");
}

BOOL CVerStamp::GetComments(CString& strInfo ) const
{
	return QueryStringInfo(strInfo, "Comments");
}

BOOL CVerStamp::GetLanguage(CString& strInfo ) const
{
	LPTRANS lpTrans;
	if (lpTrans = GetTransPtr()) {
		const int BUFSIZE = 256;
		VerLanguageName (lpTrans->wLanguage, strInfo.GetBuffer(BUFSIZE), BUFSIZE-1);
		strInfo.ReleaseBuffer();
		return TRUE;
	}
	strInfo.Empty();
	return FALSE;
}


BOOL CVerStamp::QueryStringInfo(CString& strInfo, const char *pszWhat) const
{
	BOOL bOK = FALSE;
	LPTRANS lpTrans;
	if (lpTrans = GetTransPtr()) {
		UINT nLen = 0;
		char *pszGetName  = new char[256];
		wsprintf(pszGetName, "\\StringFileInfo\\%08lx\\",MAKELONG(lpTrans->wCodePage ,lpTrans->wLanguage));
        lstrcat(pszGetName, pszWhat);

		LPVOID	lpVersion = NULL;
		if ( VerQueryValue((LPVOID)m_lpInfo, pszGetName, &lpVersion,	&nLen)
			 && nLen && lpVersion) {
			lstrcpy(strInfo.GetBuffer(nLen), (char FAR *)lpVersion);
			strInfo.ReleaseBuffer();
			bOK = TRUE;
		}
		delete [] pszGetName;
	}
	if (!bOK)
		strInfo.Empty();   // return empty string
	return bOK;
}

CVerStamp::LPTRANS CVerStamp::GetTransPtr() const  // NULL if invalid data
{
	if (m_lpInfo && m_lpTrans) {
		LPTRANS lpTrans = m_lpTrans;
		for (WORD wCnt = 0; wCnt<m_wCurrentLanguage; wCnt++) {
			lpTrans++;
		} // for wcnt
		return lpTrans;
	}
	return NULL;
}

void CVerStamp::DeleteAttribs()
{
	if (m_lpInfo) {
		delete [] m_lpInfo;
		m_lpInfo = NULL;
	}
}






///////////////////////////////////////////////////////////////////////////////
// CExeStamp

CExeStamp::ExeType CExeStamp::GetExeType(const char *pszFileName/* = 0 */)
{
	if (pszFileName != 0)
		m_eExeType = GetFileType(pszFileName);

	return m_eExeType;
}


CExeStamp::ExeType CExeStamp::GetFileType(const char *pszFName)
{
	static const WORD DOS_SIGNATURE		=0x5a4d;
	static const WORD OS2_SIGNATURE		=0x454e;
	static const WORD OS2_SIGNATURE_LE	=0x454c;
	static const WORD NT_SIGNATURE		=0x4550;         // Portable Executable
	struct EXEHEADER {
    	WORD	exSignature;	//.EXE signature
    	WORD	exExtraBytes;	//number of bytes in last (partial) page
    	WORD	exPages;		//number of whole and part pages in file
    	WORD	exRelocItems;	//number of pointers in relocation table
    	WORD	exHeaderSize;	//size of header, in paragraphs
    	WORD	exMinAlloc;		//minimum allocation
    	WORD	exMaxAlloc;		//maximum allocation
    	WORD	exInitSS;		//initial ss value

    	WORD	exInitSP;		//initial sp value
    	WORD	exCheckSum;		//complemented checksum
    	WORD	exInitIP;		//initial ip value
    	WORD	exInitCS;		//initial cs value
    	WORD	exRelocTable;	//byte offset to relocation table
    	WORD	exOverlay;		//overlay number
		// Rest of exe header only documented in MSDOS Encyclopedia 
		WORD	exRes1[3];
		WORD	exFarHeapSize;	// far heap size in paragraphs 
		WORD	exRes2[12];
		LONG	exPosNewHdr;	// file offset of new Windows/OS2 exe header 
	};

	CExeStamp::ExeType eType = ET_Error;
	CFile file;
	if (file.Open(pszFName, CFile::modeRead)) {
		EXEHEADER *pExeHeader = new EXEHEADER();
		TRY {
			if (file.Read(pExeHeader, sizeof(*pExeHeader)) == sizeof(*pExeHeader)) {
				if (pExeHeader->exSignature == DOS_SIGNATURE) {
					eType = ET_DOS;
					if  ( (pExeHeader->exPosNewHdr>sizeof(*pExeHeader))
						 && (pExeHeader->exRelocTable >= sizeof(*pExeHeader) ) ) {
						// possibly windows binary
						file.Seek(pExeHeader->exPosNewHdr, CFile::begin);
						WORD wSign;
						if (file.Read(&wSign, sizeof(wSign))==sizeof(wSign)) {
							// New .EXE headers start with these magic values.
							switch (wSign) {
								case OS2_SIGNATURE:
								case OS2_SIGNATURE_LE:
									// investigate further
									BYTE cOSFlags;
									file.Seek(pExeHeader->exPosNewHdr+0x36, CFile::begin);
									if (file.Read(&cOSFlags, sizeof(cOSFlags))==sizeof(cOSFlags)) {
									    if (cOSFlags=='\01') 
									    	eType = ET_OS2;
									    else if (cOSFlags == '\02') 
											eType = ET_Win16;
										else
											eType = ET_Unknown;
									}
									else {
										eType = ET_Unknown;
									}
									break;

								case NT_SIGNATURE:
									// investigate further
									eType = ET_Win32;
									break;
									
							}	// switch wSign
						}
					}	// if posnew
					
				} // if DOS header
				else
					eType = ET_Unknown;
			}	// if Read

		}	// TRY
		CATCH(CFileException, pException) {
			; // nothing; eType is already ET_ERROR
		}
		END_CATCH;
		delete pExeHeader;
	} // if open
	return eType;
}



