//////////////////////////////////////////////////
// CVerStamp.h: class interface to version resource info


#ifndef _INC_VERSTAMP
#define _INC_VERSTAMP

#ifdef _WIN32
#include <winver.h>
#else
#include <ver.h>
#endif

class CExeStamp;
class CVerStamp;

///////////////////////////////////////////////////////////////////////////////
// CVerStamp
class CVerStamp {
public:	
	CVerStamp();
	~CVerStamp();

	BOOL GetVersionInfo(const char *pszFileName);	// TRUE: version info obtained
	
	const VS_FIXEDFILEINFO FAR* GetFixedFileInfo() const;
    
	BOOL SelectLanguage(WORD wID ); // index, starts with 0
	WORD GetCurrentLanguage() const
		{ return m_wCurrentLanguage;};
	WORD GetLanguageCount() const
		{ return m_wLanguages; };
	// required info in stamp:
	BOOL GetLanguage(CString& strInfo ) const;
	BOOL GetFileVersion(CString& strInfo ) const;
	BOOL GetFileDescription(CString& strInfo ) const;
	BOOL GetOriginalName(CString& strInfo ) const;
	BOOL GetInternalName(CString& strInfo ) const;
	BOOL GetProductName(CString& strInfo ) const;
	BOOL GetProductVersion(CString& strInfo ) const;
	BOOL GetCompanyName(CString& strInfo ) const;
	// optional info in stamp:
	BOOL GetLegalCopyright(CString& strInfo ) const;
	BOOL GetLegalTrademarks(CString& strInfo ) const;
	BOOL GetPrivateBuild(CString& strInfo ) const;
	BOOL GetSpecialBuild(CString& strInfo ) const;
	BOOL GetComments(CString& strInfo ) const;
	
	// generic function
	BOOL QueryStringInfo(CString& strInfo, const char *pszWhat) const;

	// private member functions
private:
	typedef struct	{
		WORD wLanguage;
		WORD wCodePage;
	} TRANS;
	typedef TRANS FAR* LPTRANS;

	void	DeleteAttribs();
	LPTRANS GetTransPtr() const;
	// attributes
private:	
	DWORD	m_hVerInfo;
	BYTE	*m_lpInfo;
	LPTRANS	m_lpTrans;           // holds lang and codepage
	WORD	m_wLanguages;	// nr of languages
	WORD	m_wCurrentLanguage;
};     



///////////////////////////////////////////////////////////////////////////////
// CExeStamp
class CExeStamp {
public:	
	enum ExeType {
		ET_Error,  // file not found, or OS error
		ET_Unknown,
		ET_DOS,
		ET_Win16,
		ET_Win32,
		ET_OS2 };
	
	CExeStamp()
		 { m_eExeType = ET_Error;};
	~CExeStamp() {};

	ExeType GetExeType(const char *pszFileName = 0);

private:
	ExeType GetFileType(const char *pszFName );
	
	// attributes
private:
	ExeType	m_eExeType;
};



#endif //_INC_VERSTAMP
