/* EXAMPLE3 -- surface maps */

/* Written by Bernie Roehl, April 1994 */

#include <stdio.h>
#include <stdlib.h>

#include "avril.h"

void main()
	{
	FILE *infile;
	vrl_Light *light;
	vrl_Camera *camera;
	vrl_Shape *colorthing = NULL;
	vrl_Surface **map1, **map2;
	int i;

	vrl_SystemStartup();
	
	map1 = vrl_NewSurfacemap(6);
	map2 = vrl_NewSurfacemap(6);
	for (i = 0; i < 6; ++i)
		{
		map1[i] = vrl_NewSurface(i + 1);
		map2[i] = vrl_NewSurface(7 + i);
		}

	infile = fopen("colorful.plg", "r");
	if (infile)
		{
		colorthing = vrl_ReadPLG(infile);
		fclose(infile);
		}

	light = vrl_NewLight();
	vrl_LightRotY(light, float2angle(45));
	vrl_LightRotX(light, float2angle(45));

	camera = vrl_NewCamera();
	vrl_CameraMove(camera, 0, 100, -50);

	for (i = 0; i < 10; ++i)
		{
		vrl_Object *obj = vrl_NewObject(colorthing);
		if (i & 1)
			vrl_ObjectSetSurfacemap(obj, map1);
		else
			vrl_ObjectSetSurfacemap(obj, map2);
		vrl_ObjectMove(obj, rand() % 1000, rand() % 1000, rand() % 1000);
		}

	vrl_SystemRun();
	}

