/* EXAMPLE4 -- simple object behaviours */

/* Written by Bernie Roehl, April 1994 */

#include <stdio.h>
#include <stdlib.h>

#include "avril.h"

static Angle spinrate;
static unsigned long bounce_period;
static Scalar maxheight;
static unsigned long pulse_period;

static void spin(void)
	{
	vrl_ObjectRotY(vrl_TaskGetData(), vrl_TaskGetElapsed() * spinrate);
	vrl_SystemRequestRefresh();
	}

static void bounce(void)
	{
	vrl_Object *obj = vrl_TaskGetData();
	unsigned long off;
	Scalar height;
	off = (360 * (vrl_TaskGetTimeNow() % bounce_period)) / bounce_period;
	height = vrl_FactorMultiply(maxheight, vrl_Sine(float2angle(off)));
	vrl_ObjectMove(obj, vrl_ObjectGetX(obj), height, vrl_ObjectGetZ(obj));
	vrl_SystemRequestRefresh();
	}

static void pulsate(void)
	{
	unsigned long off;
	int brightness;
	off = (360 * (vrl_TaskGetTimeNow() % pulse_period)) / pulse_period;
	brightness = abs(vrl_FactorMultiply(255, vrl_Sine(float2angle(off))));
	vrl_SurfaceSetBrightness((vrl_Surface *) vrl_TaskGetData(), brightness);
	vrl_SystemRequestRefresh();
	}

void main()
	{
	vrl_Light *light;
	vrl_Camera *camera;
	vrl_Shape *cube, *sphere, *cylinder;
	vrl_Surface *cubesurf, *pulsesurf;
	int i;

	vrl_SystemStartup();
	
	cube = vrl_PrimitiveBox(100, 100, 100, NULL);
	sphere = vrl_PrimitiveSphere(100, 6, NULL);
	cylinder = vrl_PrimitiveCylinder(100, 50, 100, 8, NULL);

	cubesurf = vrl_NewSurface(5);
	pulsesurf = vrl_NewSurface(14);

	spinrate = float2angle(72.0 / vrl_TimerGetTickRate());  /* deg per tick */
	bounce_period = 4 * vrl_TimerGetTickRate();  /* four-second period */
	maxheight = float2scalar(400);    /* maximum height in units */
	pulse_period =  2 * vrl_TimerGetTickRate();  /* two-second period */

	light = vrl_NewLight();
	vrl_LightRotY(light, float2angle(45));
	vrl_LightRotX(light, float2angle(45));

	camera = vrl_NewCamera();
	vrl_CameraRotY(camera, float2angle(5));
	vrl_CameraMove(camera, 0, 200, -4400);

	for (i = 0; i < 10; ++i)
		{
		vrl_Object *obj = vrl_NewObject(NULL);
		vrl_ObjectMove(obj, rand() % 1000, rand() % 1000, rand() % 1000);
		switch (i & 3)
			{
			case 0:
				vrl_ObjectSetShape(obj, cube);
				break;
			case 1:
				vrl_ObjectSetShape(obj, cube);
				vrl_ObjectSetSurfacemap(obj, &cubesurf);
				vrl_TaskCreate(spin, obj, 10);
				break;
			case 2:
				vrl_ObjectSetShape(obj, sphere);
				vrl_TaskCreate(bounce, obj, 10);
				break;
			case 3:
				vrl_ObjectSetShape(obj, cylinder);
				vrl_ObjectSetSurfacemap(obj, &pulsesurf);
				break;
			}
		vrl_TaskCreate(pulsate, pulsesurf, 10);
		}

	vrl_SystemRun();
	}

