{ ======================================================================= }
{                                                                         }
{ uDebug -  dos-alike debugging help under windows without WinCrt         }
{                                                                         }
{ Author: SB                                                              }
{ Update: 18.03.94                                                        }
{                                                                         }
{ ======================================================================= }

unit uDebug;

{ ======================================================================= }
Interface
{ ======================================================================= }

uses
  winTypes,
  winProcs,
  winDos,
  Strings;

procedure AssignDebug(var F: Text);

{ ======================================================================= }
Implementation
{ ======================================================================= }

function dwOutput(var F : TTextRec) : Integer; far;
var
  Tmp             : array[0..255] of char;
begin
  if F.BufPos<>0 then
  begin
    OutputDebugString(StrLCopy(Tmp,PChar(F.BufPtr),F.BufPos));
    F.BufPos:=0;
  end;
  dwOutput:=0;
end;

{ ----------------------------------------------------------------------- }

function dwClose(var F : TTextRec) : Integer; far;
begin
  dwClose:=0;
end;

{ ----------------------------------------------------------------------- }

function dwOpen(var F : TTextRec) : Integer; far;
begin
  F.Mode:=fmOutput;
  F.InOutFunc:=@dwOutput;
  F.FlushFunc:=@dwOutput;
  F.CloseFunc:=@dwClose;
  dwOpen:=0;
end;

{ ----------------------------------------------------------------------- }

procedure AssignDebug(var F: Text);
begin
  with TTextRec(F) do
  begin
    Handle:=$FFFF;
    Mode:=fmClosed;
    BufSize:=SizeOf(Buffer);
    BufPtr:=@Buffer;
    OpenFunc:=@dwOpen;
    Name[0]:=#0;
  end;
end;

{ ----------------------------------------------------------------------- }

begin
  AssignDebug(Output);
  Rewrite(Output);
end.