#include "stdafx.h"
#include "filelook.h"

#define GUESS       100L
#define MAXLINES    200
#define TABNUM 8


IMPLEMENT_DYNAMIC(CLineFile, CFile)

CLineFile::~CLineFile()
{
}

CLineFile::CLineFile() : CFile()
{
    m_lBeginLine = 0L;
}

CLineFile::CLineFile(const char* pszFileName, UINT nOpenFlags)
        : CFile(pszFileName, nOpenFlags)
{
    m_lBeginLine = 0L;
}



LONG CLineFile::NextLine(char FAR* lpszArg, UINT nMax)
{
    char FAR * lpsz = lpszArg;
    UINT n;

    m_lBeginLine = GetPosition();

    for (n=0;;){
        if ( Read( lpsz, 1) != 1 ){
          DWORD pos = GetPosition();
          DWORD len = GetLength();
          break;
        }
        n++;
        if ( *lpsz == '\n' ) break;
        if ( *lpsz == '\r' ) continue;
        if ( *lpsz == '\t' ){
          for ( *lpsz++ = ' '; n%TABNUM && n < nMax; n++, lpsz++ ){
             *lpsz = ' ';
          }
        }
        else lpsz++;

        if ( n >= nMax ) break;
    }

    *lpsz = '\0';
    return GetPosition();
}
                
                
LONG CLineFile::SetBegin(LONG newBegin)
{
    LONG save = m_lBeginLine;
    m_lBeginLine = newBegin;
    return save;
}


LONG CLineFile::LineNear(char FAR* lpsz, UINT nMax, LONG  lOffset)
{
    Seek(lOffset, CFile::begin);
    m_lBeginLine = NextLine(lpsz, nMax);   
    return BackLines( lpsz, nMax, 1 );   
}
   
   

LONG CLineFile::BackLines(char FAR* lpsz, UINT nMax, UINT nLines)
{
    LONG    lines[ MAXLINES ];
    LONG    guess, orgBeginLine;
    UINT i;

    orgBeginLine=m_lBeginLine;
    if (m_lBeginLine == 0L){
        Seek(0L, CFile::begin);
        return NextLine(lpsz, nMax);
    }

    if (nLines > MAXLINES){
        nLines = MAXLINES;
    }

    guess = m_lBeginLine - ( nMax * nLines );

    if (guess < 0L){
        guess = 0L;
    }
    Seek( guess, CFile::begin);

    if (guess != 0L){
        NextLine( lpsz, nMax );   
    }                             
    
    for ( i = 0; i < nLines; i++ )  {
      lines[i]=GetPosition();
      NextLine( lpsz, nMax );
    }                             
    
    while (GetPosition() < (DWORD)orgBeginLine){
      for (i = 0; i < nLines-1; i++){
        lines[i]= lines[i+1];
      }
      lines[nLines-1]=GetPosition();
      NextLine(lpsz, nMax);
    }
    
    Seek( lines[ 0], CFile::begin );
    NextLine( lpsz, nMax );
    m_lBeginLine = lines[ 0 ];
    return m_lBeginLine;
}




