/* PCX.C
 *
 * PCX file reader and writer
*/
#include <dos.h>
#include <stdio.h>
unsigned int n=0;
char far *screen=(char far*) MK_FP(0xa000,0);
typedef struct
{   char manufacturer;
	char version;
	char encoding;
    char bitsperpixel;
    int xmin;
    int ymin;
    int xmax;
    int ymax;
	int hres;
	int vres;
    char colormap[48];
	char reserved;
    char nplanes;
    int bytesperline;
    int palettetype;
	char filler[58];
} PCXHEADER;

PCXHEADER pcxhdr;

void video12h()
 {
     _asm{
	   MOV     ah,0
	   MOV     al,12h   // load 12h mode 640x480x256 colors
	   INT     10h
	   }
}


/* Read an entire file and store it in a (large) buffer,
   pointed to by the variable bufr
   filename is the name of the file,
   including the .pcx extension */

int readpcx(char *bufr, char *filename)
{   int i;
    long l, linesize;
    unsigned char block, count;
    FILE *pcxfile;
    if ((pcxfile = fopen(filename, "rb")) == NULL) return(0);
    pcxhdr.manufacturer = getc(pcxfile);
    if (pcxhdr.manufacturer != 10)
    {   fclose(pcxfile);
	return(0);
    }
    pcxhdr.version = getc(pcxfile);
    pcxhdr.encoding = getc(pcxfile);
    pcxhdr.bitsperpixel = fgetc(pcxfile);
    pcxhdr.xmin = getw(pcxfile);
    pcxhdr.ymin = getw(pcxfile);
    pcxhdr.xmax = getw(pcxfile);
    pcxhdr.ymax = getw(pcxfile);
    pcxhdr.hres = getw(pcxfile);
    pcxhdr.vres = getw(pcxfile);
    fread(pcxhdr.colormap, 48, sizeof(char), pcxfile);
    pcxhdr.reserved = getc(pcxfile);
    pcxhdr.nplanes = getc(pcxfile);
    pcxhdr.bytesperline = getw(pcxfile);
    pcxhdr.palettetype = getw(pcxfile);
    fread(pcxhdr.filler, 58, sizeof(char), pcxfile);
    linesize = (long) pcxhdr.bytesperline * pcxhdr.nplanes *
		   (1 + pcxhdr.ymax - pcxhdr.ymin);
    for (l = 0; l < linesize; )             /* increment by count below */
    {   if (readpcxblock(&block, &count, pcxfile) == EOF) break;
	for (i = 0; i < count; i++)
	    *bufr++ = block;
	l += count;
    }
}

/* Read one encoded block from the pcx
   file and store a count and data byte.
   If the code is greater than 0xc0 (192), go for a run.
   Otherwise, just grab a byte.
   Result: 0 = valid data stored
	   EOF = out of data in file

    int *pblock;      where to place data
    int *pcount;      where to place count
    FILE *pcxfile;         image file handle
*/

int readpcxblock(int *pblock, int *pcount, FILE *pcxfile)
{   int i;
    *pcount = 1;
    if ((i = getc(pcxfile)) == EOF) return(EOF);
    if (0xc0 == (0xc0 & i))      /* is it greater than 192? */
    {   *pcount = 0x3f&i;      /* subtract 192 to get count */
	if((i = getc(pcxfile)) == EOF) return(EOF);
    }
    *pblock = i;
    return(0);
}

main()
{
 video12h();
 readpcx(screen,"win1.pcx");
getch();
}
