; Programm: Beispiel 2
; Funktion: Grafikdemonstration
; Sprache:  PASM 1.0
;
;        Copyright 1994 by
; Peter Panas Software Development
;
; Definition des Codesegments
code     segment para 'code'
;
; Defintion der Prozedur Kasten
Kasten   proc    far
;
; Segment festlegen
         assume cs: code
;
; Sichern der wichtigsten Speicherwerte
         push    ax
         push    bx
         push    cx
         push    dx
;
; Definieren des Bildschirmmodus
         mov     ah,0
         int     10h
;
; Ermitteln der aktiven Bildschirmseite
         mov     ah,15
         int     10h
;
; Interruptfunktion 'Positioniere Cursor'
; ausfhren
         mov     dx,0
         mov     ah,2
         int     10h
;
; 39 Zeichen ausgeben auf Position 0,0
         mov     cx,39
;
; Das ASCII-Zeichen 205 an der Cursor-
; position auf dem Bildschirm ausgeben
         mov     ah,10
         mov     al,205
         int     10h
;
; Einmal das ASCII-Zeichen 201
; auf dem Bildschirm ausgeben
         mov     cx,1
         mov     al,201
         mov     ah,10
         int     10h
;
; Spalte auf die rechte, obere Ecke setzen
; und entsprechendes Zeichen darstellen
         add     dl,39
         mov     ah,2
         int     10h
         mov     cx,1
         mov     al,187
         mov     ah,10
         int     10h
;
; Cursor auf untere, rechte Ecke setzen
         add     dh,24
         mov     ah,2
         int     10h
;
; ASCII-Zeichen 188 als
; Kennzeichen markieren
         mov     al,188
         mov     ah,10
         int     10h
;
; Die untere, linke Ecke zeichnen
         sub     dl,39
         mov     ah,2
         int     10h
;
; Wiederum 39mal das Zeichen 205
; auf den Monitor bringen
         mov     cx,39
         mov     al,205
         mov     ah,10
         int     10h
;
; Einmal das Zeichen 200 positionieren
         mov     cx,1
         mov     al,200
         mov     ah,10
         int     10h
;
; Jedes Zeichen einmal darstellen
         mov     cx,1
;
; Zeile um eins vermindern und
; Cursor positionieren
Seiten:  dec     dh
         mov     ah,2
         int     10h
;
; Zeichen fr eine Seite
         mov     al,186
;
; Danach Zeichen ausgeben
         mov     ah,10
         int     10h
;
; Spalte auf die rechte Seite setzen
         add     dl,39
         mov     ah,2
         int     10h
;
; Zeichen fr eine Seite
         mov     al,186
;
; Seitenzeichen darstellen
         mov     ah,10
         int     10h
;
; Spalte auf ursprnglichen Wert
         sub     dl,39
;
; Erste Zeile erreicht ?
         cmp     dh,1
;
; Wenn nicht, Sprung zu Seiten
         jne     Seiten
;
; Koordinaten 1,1
         mov     dx,101h
;
; Neue Cursorposition einrichten
Animat:  mov     ah,2
         int     10h
;
; Gesicht an Cursorposition zeigen
         mov     al,1
         mov     ah,10
         int     10h
;
; Aufruf der Zeitverzgerung
         call    warten
;
; Wenn Taste gedrckt, dann
; Sprung zum Ende der Routine
         mov     ah,11
         int     21h
         cmp     al,0
         jnz     Schluss
;
; Ausgabe anwhlen
         mov     ah,10
;
; Gesicht wieder lschen
         mov     al,32
         int     10h
;
; Spalte erhhen
         inc     dl
;
; Wenn rechter Rand nicht erreicht, Routine
; wiederholen, sonst Spalte = 1
         cmp     dl,39
         jne     Animat
         mov     dl,1
;
; Zeile erhhen
         inc     dh
;
; Wenn untere Zeile nicht erreicht,
; Routine wiederholen, sonst
; Zeile = 1 und weitermachen
         cmp     dh,24
         jne     Animat
         mov     dh,1
;
; Fr den TASM/MASM mssen Sie die folgende
; Zeile durch 'jmp Animat' ersetzen
         jmps    Animat
;
; Anfang der Zeitverzgerungsroutine
Warten   proc    near
;
; Die anderweitig benutzten
; Register sichern
         push    cx
         push    dx
;
; CX-Register lschen
         xor     cx,cx
;
; DX-Register lschen
         xor     dx,dx
;
; Systemzeit auf Null setzen
         mov     ah,1
         int     1ah
;
; Funktion Null liest die Systemuhr
         xor     ah,ah
;
; Uhr auslesen
Zehntel: int     1ah
;
; 2/18,2 Sekunden warten
         cmp     dl,2
         jne     Zehntel
;
; Gesicherte Register wieder zurckholen
         pop     dx
         pop     cx
;
; Rckkehr ins Hauptprogramm
         ret
;
; Ende der Prozedur
Warten   endp
;
; Cursor unter dem Kasten positionieren
Schluss: mov     dh,15
         mov     ah,2
         int     10h
;
; Die auf dem Stapel gesicherten
; Werte wiederherstellen
         pop     dx
         pop     cx
         pop     bx
         pop     ax
;
; Rckkehr in die MS-DOS-Ebene
         mov     ah,4ch
         int     21h
;
; Ende der Prozedur
Kasten   endp
;
; Ende des Code-Segments
code     ends
;
; Ende des Programms
         end     Kasten