/*******************************************************************************
**	Program Name..	Winbtrv.lib
**	Module Name...	Btrfld.h
**	Programmer....	Jeffrey K Regan
**	Creation Date.	01/10/94
********************************************************************************
**	Copyright (c) 1994, Jeffrey K Regan                                        **
*******************************************************************************/
#ifndef _BTRFIELD_H
#define _BTRFIELD_H

#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <mem.h>
#include <math.h>

#include <btrenv.h>
#include <btrobj.h>
#include <btrddf.h>

class btrField : public btrObject
	{
public:
	char	*shortName;
	btrFieldType	type;

public:
	btrField ();
   btrField (char *sname, char *lname, void *src, void *dst, const btrFieldType tp, const int len = 0, const int dec = 0);
	btrField (char *sname, char *dataBuf, void *dst, ddfField &fldSpec);
	btrField (const btrField &Field);
	~btrField ();

	int operator == (const btrField &fld) { return strcmp (shortName, fld.shortName); }
   char *getShortName () { return getName (); }
   char *getLongName () { return rep->getName (); }
	btrField * operator -> () { return rep; }
	virtual void Read () { rep->Read (); }
	virtual void Write () { rep->Write (); }   
	virtual void Clear () { rep->Clear (); }
	virtual int getSize () { return rep->getSize (); }
	virtual int getLength () { return rep->getLength (); }
	virtual Boolean isChanged () { return rep->isChanged (); }
	virtual void *getDestination () { return rep->getDestination (); }
	virtual void setDestination (void *newdst) { rep->setDestination (newdst); }
	virtual char *getName () { return shortName; }
	virtual char *nameOf () const { return "Btrieve Field"; }
	virtual void printOn (ostream& os);

private:   
	btrField *setUpField (const char *lname, void *src, void *dst, const btrFieldType tp, const int len = 0, const int dec = 0);

private:
	btrField *rep;
	};

class btrStringField : public btrField
	{
public:
	btrStringField (const char *lname, void *src, void *dst, const int len);
	~btrStringField ();

	void Read () { fldcpy ((char *) destination, (char *) source, length, True); }
	void Write () { fldcpy ((char *) source, (char *) destination, length, False); }
	void Clear () { memset ((char *) destination, '\0', length); }
	int getSize () { return (length - 1); }
	int getLength () { return strlen ((char *) destination); }
	void *getDestination () { return destination; }
	void setDestination (void *newdst) { destination = newdst; }
	Boolean isChanged () { return (strcmp ((char *) destination, (char *) source) != 0) ? True : False; }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve String Field"; }
	virtual void printOn (ostream& os);

private:
	char *longName;
	void *source, *destination;

	int	length;

	char *value;
	};

class btrCharField : public btrField
	{
public:   
	btrCharField (const char *lname, void *src, void *dst);
	~btrCharField ();

	void Read () { *(unsigned char *) destination= *(unsigned char *) source; }
	void Write () { *(unsigned char *) source = *(unsigned char *) destination; }
	void Clear () { *(unsigned char *) destination = 0; }
	int getSize () { return sizeof (char); }
	int getLength () { return sizeof (char); }  
	void *getDestination () { return destination; }
	void setDestination (void *newdst) { destination = newdst; }
	Boolean isChanged () { return (*(unsigned char *) destination != *(unsigned char *) source) ? True : False; }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Integer Field (length 1)"; }
	virtual void printOn (ostream& os);

private:
	char *longName;
	void *source, *destination;

	unsigned char	value;   
	};
   
class btrIntegerField : public btrField
	{
public:   
	btrIntegerField (const char *lname, void *src, void *dst);
	~btrIntegerField ();

	void Read () { *(int *) destination = *(int *) source; }
	void Write () { *(int *) source = *(int *) destination; }
	void Clear () { *(int *) destination = 0; }
	int getSize () { return sizeof (int); }
	int getLength () { return sizeof (int); }
	void *getDestination () { return destination; }
	void setDestination (void *newdst) { destination = newdst; }
	Boolean isChanged () { return (*(int *) destination != *(int *) source) ? True : False; }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Integer Field (length 2)"; }
	virtual void printOn (ostream& os);

private:
	char *longName;
	void *source, *destination;

	int	value;   
	};
   
class btrLongField : public btrField
	{
public:   
	btrLongField (const char *lname, void *src, void *dst);
	~btrLongField ();

	void Read () { *(long *) destination = *(long *) source; }
	void Write () { *(long *) source = *(long *) destination; }
	void Clear () { *(long *) destination = 0l; }
	int getSize () { return sizeof (long); }
	int getLength () { return sizeof (long); }
	void *getDestination () { return destination; }
	void setDestination (void *newdst) { destination = newdst; }
	Boolean isChanged () { return ((*(long *) destination != *(long *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Integer Field (length 4)"; }
	virtual void printOn (ostream& os);

private:
	char *longName;
	void *source, *destination;

	long	value;   
	};
   
class btrFloatField : public btrField
	{
public:   
   btrFloatField (const char *lname, void *src, void *dst);
   ~btrFloatField ();
   
	void Read () { *(float *) destination = *(float *) source; }
   void Write () { *(float *) source = *(float *) destination; }
   void Clear () { *(float *) destination = 0.0; }
   int getSize () { return sizeof (float); }
   int getLength () { return sizeof (float); }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(float *) destination != *(float *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Float Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	float	value;   
   };
   
class btrDoubleField : public btrField
	{
public:   
   btrDoubleField (const char *lname, void *src, void *dst);
   ~btrDoubleField ();

	void Read () { *(double *) destination = *(double *) source; }
   void Write () { *(double *) source = *(double *) destination; }
   void Clear () { *(double *) destination = 0.0; }
   int getSize () { return sizeof (double); }
   int getLength () { return sizeof (double); }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(double *) destination != *(double *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Double Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	double	value;   
   };
   
class btrLongDoubleField : public btrField
	{
public:   
   btrLongDoubleField (const char *lname, void *src, void *dst);
   ~btrLongDoubleField ();
   
	void Read () { *(long double *) destination = *(long double *) source; }
   void Write () { *(long double *) source = *(long double *) destination; }
   void Clear () { *(long double *) destination = 0.0; }
   int getSize () { return sizeof (long double); }
   int getLength () { return sizeof (long double); }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(long double *) destination != *(long double *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Long Double Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	long double	value;   
   };
   
class btrDateField : public btrField
	{
public:           
	btrDateField (const char *lname, void *src, void *dst);
   ~btrDateField ();
   
	void Read () { *(long *) destination = *(long *) source; }
   void Write () { *(long *) source = *(long *) destination; }
   void Clear () { *(long *) destination = 0l; }
   int getSize () { return sizeof (long); }
   int getLength () { return sizeof (long); } 
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(long *) destination != *(long *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Date Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	long	value;   
   };
   
class btrTimeField : public btrField
	{
public:           
	btrTimeField (const char *lname, void *src, void *dst);
   ~btrTimeField ();
   
	void Read () { *(long *) destination = *(long *) source; }
   void Write () { *(long *) source = *(long *) destination; }
   void Clear () { *(long *) destination = 0l; }
   int getSize () { return sizeof (long); }
   int getLength () { return sizeof (long); } 
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(long *) destination != *(long *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Time Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	long	value;
   };
   
class btrDecimalField : public btrField
	{
public:           
	btrDecimalField (const char *lname, void *src, void *dst, const int len, const int dec = 0);
   ~btrDecimalField ();
   
	void Read ();
   void Write ();
   void Clear () { *(double *) destination = 0.00; }
   int getSize () { return length; }
   int getLength () { return length; }        
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();                         
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Decimal Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
   int	blength;
   int	decimals;
   
   double	value;
   
	char *invalue;
   double	origValue;
   char *inbuffer;
   };
   
class btrMoneyField : public btrField
	{
public:           
	btrMoneyField (const char *lname, void *src, void *dst, const int len);
   ~btrMoneyField ();
   
	void Read ();
   void Write ();
   void Clear () { *(double *) destination = 0.00; }
   int getSize () { return length; }
   int getLength () { return length; }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Money Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
   int	blength;
	int   decimals;
   
   double	value;
   
   char *invalue;
   double	origValue;
   char *inbuffer;    
   };
   
class btrCharLogicalField : public btrField
	{
public:           
	btrCharLogicalField (const char *lname, void *src, void *dst);
   ~btrCharLogicalField ();
   
	void Read () { *(char *) destination = *(char *) source; }
   void Write () { *(char *) source = *(char *) destination; }
   void Clear () { *(char *) destination = 0; }
   int getSize () { return sizeof (unsigned char); }
   int getLength () { return sizeof (unsigned char); }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(char *) destination != *(char *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Logical Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	unsigned char	value;
   };
   
class btrIntLogicalField : public btrField
	{
public:           
	btrIntLogicalField (const char *lname, void *src, void *dst);
   ~btrIntLogicalField ();
   
	void Read () { *(int *) destination = *(int *) source; }
   void Write () { *(int *) source = *(int *) destination; }
   void Clear () { *(int *) destination = 0; }
   int getSize () { return sizeof (int); }
   int getLength () { return sizeof (int); }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return ((*(int *) destination != *(int *) source) ? True : False); }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Logical Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	value;
   };
   
class btrNumericField : public btrField
	{
public:           
	btrNumericField (const char *lname, void *src, void *dst, const int len, const int dec = 0);
   ~btrNumericField ();
   
	void Read ();
   void Write ();
   void Clear () { *(double *) destination = 0.00; }
   int getSize () { return length; }
   int getLength () { return length; }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();                 
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Numeric Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
   int	blength;
   int	decimals;
   
	double	value;
   
   char *invalue;
   double	origValue;
   char *inbuffer;    
   };
   
class btrLStringField : public btrField
	{
public:           
	btrLStringField (const char *lname, void *src, void *dst, const int len);
   ~btrLStringField ();
   
	void Read ();
   void Write ();
   void Clear () { memset ((char *) destination, '\0', length); }
   int getSize () { return length - 1; }
   int getLength () { return length; }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();                 
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve LString Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
   char *value;
   char *inbuffer;
   };
   
class btrZStringField : public btrField
	{
public:           
	btrZStringField (const char *lname, void *src, void *dst, const int len);
   ~btrZStringField ();
   
	void Read () { memcpy ((char *) destination, (char *) source, length); }
   void Write () { memcpy ((char *) source, (char *) destination, length); }
   void Clear () { memset ((char *) destination, '\0', length); }
   int getSize () { return length; }
   int getLength () { return length; }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged () { return (strcmp ((char *) destination, (char *) source) != 0) ? True : False; }
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve ZString Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
   char *value;
   };
   
class btrNoteField : public btrField
	{
public:   
   btrNoteField (const char *lname, void *src, void *dst, const int len);
   ~btrNoteField ();
   
	void Read () { memcpy ((char *) destination, (char *) source, length); }
   void Write () { memcpy ((char *) source, (char *) destination, length); }
   void Clear () { memset ((char *) destination, '\0', length); }
   int getSize () { return length; }
   int getLength () { return length; }
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();                 
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve Note Field"; }
	virtual void printOn (ostream& os);
private:
	char *longName;
	void *source, *destination;

	int	length;
	char *value;
	};

class btrLVarField : public btrField
	{
public:   
   btrLVarField (const char *lname, void *src, void *dst, const int len);
   ~btrLVarField ();
   
	void Read ();
   void Write ();
   void Clear ();
   int getSize () { return length; }
   int getLength ();
   void *getDestination () { return destination; }
   void setDestination (void *newdst) { destination = newdst; }
   Boolean isChanged ();
	char *getName () { return longName; }
	virtual char *nameOf () const { return "Btrieve LVar Field"; }
	virtual void printOn (ostream& os);
private:
	void getLVar ();
   void putLVar ();   
private:
	char *longName;
	void *source, *destination;

	int	length;
	char *value;
   char *invalue;
	};

#endif
